using System;
using System.Collections.Generic;

namespace ConsoleApp12
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Uneti broj jarbola:");
            int brojJarbola = int.Parse(Console.ReadLine());

            Console.WriteLine("Uneti udaljenost od pramca (razdvojeno razmakom):");
            string udaljenost = Console.ReadLine();
            string[] udaljenoststring = udaljenost.Split(' ');
            List<long> udaljenostint = new List<long>();
            foreach (string udalj in udaljenoststring)
            {
                if (long.TryParse(udalj, out long udaljint))
                {
                    udaljenostint.Add(udaljint);
                }
            }

            Console.WriteLine("Uneti visine jarbola (razdvojeno razmakom):");
            string visine = Console.ReadLine();
            string[] visinestring = visine.Split(' ');
            List<long> visineint = new List<long>();
            foreach (string visina in visinestring)
            {
                if (long.TryParse(visina, out long visinaint))
                {
                    visineint.Add(visinaint);
                }
            }

            if (udaljenostint.Count != visineint.Count || udaljenostint.Count == 0)
            {
                Console.WriteLine("Greska broj unetih pozicija i visina mora biti isti i veci od nule.");
                return;
            }

            long[] xArray = udaljenostint.ToArray();
            long[] hArray = visineint.ToArray();

            long[] results = Solve(xArray, hArray);

            Console.WriteLine("Rezultati (najbliza rastojanja za svaki jarbol):");
            foreach (long dist in results)
            {
                Console.WriteLine(dist);
            }
        }

        public static long[] Solve(long[] x, long[] h)
        {
            int n = x.Length;
            long[] leftDistances = new long[n];
            long[] rightDistances = new long[n];
            long[] finalResults = new long[n];

            for (int i = 0; i < n; i++)
            {
                leftDistances[i] = long.MaxValue;
                rightDistances[i] = long.MaxValue;
            }

            Stack<int> stack = new Stack<int>();

            for (int i = 0; i < n; i++)
            {
                while (stack.Count > 0 && h[stack.Peek()] < h[i])
                {
                    stack.Pop();
                }

                if (stack.Count > 0)
                {
                    int leftIndex = stack.Peek();
                    leftDistances[i] = Math.Abs(x[i] - x[leftIndex]);
                }

                stack.Push(i);
            }

            stack.Clear();
            for (int i = n - 1; i >= 0; i--)
            {
                while (stack.Count > 0 && h[stack.Peek()] < h[i])
                {
                    stack.Pop();
                }

                if (stack.Count > 0)
                {
                    int rightIndex = stack.Peek();
                    rightDistances[i] = Math.Abs(x[i] - x[rightIndex]);
                }

                stack.Push(i);
            }

            for (int i = 0; i < n; i++)
            {
                long minDist = Math.Min(leftDistances[i], rightDistances[i]);
                finalResults[i] = (minDist == long.MaxValue) ? -1 : minDist;
            }

            return finalResults;
        }
    }
}